<?php

namespace XenSoluce\SEOOptimization\XF\Pub\Controller;

use XF\Mvc\ParameterBag;

class Thread extends XFCP_Thread
{
    public function actionSeo(ParameterBag $params)
    {
        $thread = $this->assertViewableThread($params->thread_id);
        $seo = $this->plugin('XenSoluce\SEOOptimization:SEO');

        return $seo->actionSeo($thread, 'threads');
    }

    protected function setupThreadEdit(\XF\Entity\Thread $thread)
    {
        $editor = parent::setupThreadEdit($thread);

        $editor->setTitle(\XF::repository('XF:Thread')->changeThreadTitle($editor->getThread()->title));

        if(\XF::visitor()->canEditSeoOwnEntity($thread, $error))
        {
            $input['xs_seo'] = $this->filter('xs_seo', 'array-str');
        }

        if(empty($input['xs_seo']['save_url']))
        {
            $input['xs_seo_title'] = $editor->getThread()->title;
        }
        else
        {
            $input['xs_seo_title'] = $this->filter('xs_seo_title', 'str');
        }

        $thread = $editor->getThread()->bulkSet($input);

        return $editor;
    }
}