<?php

namespace XenSoluce\SEOOptimization\Template;

use XenSoluce\SEOOptimization\Repository\SEOOptimization;
use XenSoluce\SEOOptimization\SEO\AbstractHandler;
use XF\Mvc\Entity\Entity;

/**
 * Class TemplaterSetup
 * @package XenSoluce\SEOOptimization\Template
 */
class TemplaterSetup
{
    /**
     * @param \XF\Template\Templater $templater
     * @param $escape
     * @param string $entity
     * @param string $page
     * @return string|string[]|null
     */
    public function fnXsChangeTitle(\XF\Template\Templater $templater, &$escape, $entity = '', $page = '')
    {
        $page = intval($page);
        $pageNum = '';
        if($page > 1)
        {
            $pageNum = \XF::app()->language()->phrase('xs_seo_page_x', ['page' => $page]);
        }
        $handler = $this->getSEOHandler($entity, $templater);
        return $handler->changeTitle($escape, ['pageNum' => $pageNum]);
    }

    /**
     * @param \XF\Template\Templater $templater
     * @param $escape
     * @param string $data
     * @param string $original
     * @return mixed|string
     */
    public function fnXsChangeCanonical(\XF\Template\Templater $templater, &$escape, $data = '', $original = '')
    {
        if(!empty($data->xs_seo['canonical_url']))
        {
            return $data->xs_seo['canonical_url'];
        }
        
        return $original;
    }

    /**
     * @param \XF\Template\Templater $templater
     * @param $escape
     * @param string $entity
     * @param string $default
     * @return mixed|string|Entity
     */
    public function fnXsChangeOpenGraph(\XF\Template\Templater $templater, &$escape, $entity = '', $default = '')
    {
        $handler = $this->getSEOHandler($entity, $templater);
        return $handler->getOpenGraph($default);
    }

    /**
     * @param \XF\Template\Templater $templater
     * @param $escape
     * @param string $entity
     * @return mixed|string|string[]|null
     */
    public function fnXsChangeDescription(\XF\Template\Templater $templater, &$escape, $entity = '')
    {
        if(!empty($entity->xs_seo['meta_description']))
        {
            return $templater->escape($entity->xs_seo['meta_description'], $escape);
        }
        $handler = $this->getSEOHandler($entity, $templater);
        return $handler->changeDescription($escape);
    }

    /**
     * @param \XF\Template\Templater $templater
     * @param $escape
     * @param $entity
     * @param $arrayInstanceOf
     * @return bool
     */
    public function fnXsInstanceOf(\XF\Template\Templater $templater, &$escape, $entity, $arrayInstanceOf)
    {
        foreach ($arrayInstanceOf as $instance)
        {
            if($entity instanceof $instance)
            {
                return true;
            }
        }

        return false;
    }

    /**
     * @param Entity $entity
     * @param $templater
     * @return AbstractHandler
     */
    protected function getSEOHandler(Entity $entity, $templater): AbstractHandler
    {
        /** @var SEOOptimization $seoRepo */
        $seoRepo = \XF::app()->repository('XenSoluce\SEOOptimization:SEOOptimization');

        /** @var AbstractHandler $handler */
        $handler = $seoRepo->getSEOHandler($entity->getEntityContentType());
        $handler->setEntity($entity);
        $handler->setTemplater($templater);

        return $handler;
    }
}