<?php

namespace XenSoluce\SEOOptimization;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;
use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;
use XF\Db\SchemaManager;

class Setup extends AbstractSetup
{
    use StepRunnerInstallTrait;
    use StepRunnerUpgradeTrait;
    use StepRunnerUninstallTrait;

    public function installStep1()
    {
        $sm = $this->schemaManager();
        $sm->alterTable('xf_node', function (Alter $table) {
            $table->addColumn('xs_seo', 'blob')->nullable(true);
            $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
        });

        $sm->alterTable('xf_thread', function (Alter $table) {
            $table->addColumn('xs_seo', 'blob')->nullable(true);
            $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
        });

        $sm->alterTable('xf_thread_prefix', function (Alter $table) {
            $table->addColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
        });

        $this->changeRoute();
    }

    public function installStep2()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_rm_category')) {
            $sm->alterTable('xf_rm_category', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_rm_resource')) {
            $sm->alterTable('xf_rm_resource', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_rm_resource_prefix')) {
            $sm->alterTable('xf_rm_resource_prefix', function (Alter $table) {
                $table->addColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
            });
        }
    }

    public function installStep3()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_mg_category')) {
            $sm->alterTable('xf_mg_category', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_mg_album')) {
            $sm->alterTable('xf_mg_album', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_mg_media_item')) {
            $sm->alterTable('xf_mg_media_item', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }
    }

    public function installStep4()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_xa_ams_article')) {
            $sm->alterTable('xf_xa_ams_article', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }
    }


    public function onActiveChange($newActive, array &$jobList)
    {
        if ($newActive) {
            $this->changeRoute();
        } else {
            $this->changeRoute(true);
        }
    }

    protected function changeRoute($drop = false, $filter = [])
    {
        $routes = [
            'threads' => [
                [
                    'context' => 'forums',
                    'format' => ':int<thread_id,title>/:page',
                    'replace' => ':int<thread_id,xs_seo_title>/:page'
                ],
                [
                    'context' => 'forums',
                    'format' => ':+int<thread_id,title>/post-:+int_p<post_id>',
                    'replace' => ':+int<thread_id,xs_seo_title>/post-:+int_p<post_id>'
                ]
            ],
            'resources' => [
                [
                    'context' => 'xfrm',
                    'format' => ':int<resource_id,title>/',
                    'replace' => ':int<resource_id,xs_seo_title>/'
                ],
            ],
            'albums' => [
                [
                    'context' => 'xfmg',
                    'format' => 'albums/:int<album_id,title>/:page',
                    'replace' => 'albums/:int<album_id,xs_seo_title>/:page'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'album-comments/:int<album_id,title>/',
                    'replace' => 'album-comments/:int<album_id,xs_seo_title>/'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'album-ratings/:int<album_id,title>/',
                    'replace' => 'album-ratings/:int<album_id,xs_seo_title>/'
                ]
            ],
            'media' => [
                [
                    'context' => 'xfmg',
                    'format' => ':int<media_id,title>/:page',
                    'replace' => ':int<media_id,xs_seo_title>/:page'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'media-comments/:int<media_id,title>/',
                    'replace' => 'media-comments/:int<media_id,xs_seo_title>/'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'media-ratings/:int<media_id,title>/',
                    'replace' => 'media-ratings/:int<media_id,xs_seo_title>/'
                ]
            ]
        ];

        if (!empty($filter)) {
            $routes = array_filter($routes, function ($prefix) use ($filter) {
                return in_array($prefix, $filter);
            }, ARRAY_FILTER_USE_KEY);
        }

        foreach ($routes as $prefix => $route) {
            foreach ($route as $value) {
                if ($drop) {
                    $findRoute = $this->app->finder('XF:Route')->where([
                        'route_type' => 'public',
                        'route_prefix' => $prefix,
                        'format' => $value['replace'],
                        'context' => $value['context']
                    ])->fetchOne();
                    if ($findRoute) {
                        $findRoute->format = $value['format'];
                        $findRoute->save();
                    }
                } else {
                    $findRoute = $this->app->finder('XF:Route')->where([
                        'route_type' => 'public',
                        'route_prefix' => $prefix,
                        'format' => $value['format'],
                        'context' => $value['context']
                    ])->fetchOne();
                    if ($findRoute) {
                        $findRoute->format = $value['replace'];
                        $findRoute->save();
                    }
                }
            }
        }
    }

    public function upgrade2030020Step1()
    {
        $sm = $this->schemaManager();
        $sm->alterTable('xf_node', function (Alter $table) {
            $table->addColumn('xs_seo', 'blob')->nullable(true);
        });

        $sm->alterTable('xf_thread', function (Alter $table) {
            $table->addColumn('xs_seo', 'blob')->nullable(true);
        });

        $sm->alterTable('xf_thread_prefix', function (Alter $table) {
            $table->addColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
        });
    }

    public function upgrade2030020Step2()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_rm_category')) {
            $sm->alterTable('xf_rm_category', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
            });
        }

        if ($sm->tableExists('xf_rm_resource')) {
            $sm->alterTable('xf_rm_resource', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
            });
        }

        if ($sm->tableExists('xf_rm_resource_prefix')) {
            $sm->alterTable('xf_rm_resource_prefix', function (Alter $table) {
                $table->addColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
            });
        }
    }

    public function upgrade2030020Step3()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_mg_category')) {
            $sm->alterTable('xf_mg_category', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
            });
        }

        if ($sm->tableExists('xf_mg_album')) {
            $sm->alterTable('xf_mg_album', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
            });
        }

        if ($sm->tableExists('xf_mg_media_item')) {
            $sm->alterTable('xf_mg_media_item', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
            });
        }
    }

    public function upgrade2060000Step1()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_xa_ams_article')) {
            $sm->alterTable('xf_xa_ams_article', function (Alter $table) {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
            });
        }
    }

    public function upgrade2060200Step1()
    {
        $sm = $this->schemaManager();
        $sm->alterTable('xf_node', function (Alter $table) {
            $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
        });

        $sm->alterTable('xf_thread', function (Alter $table) {
            $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
        });

        if ($sm->tableExists('xf_rm_category')) {
            $sm->alterTable('xf_rm_category', function (Alter $table) {
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }
        if ($sm->tableExists('xf_rm_resource')) {
            $sm->alterTable('xf_rm_resource', function (Alter $table) {
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_mg_category')) {
            $sm->alterTable('xf_mg_category', function (Alter $table) {
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_mg_album')) {
            $sm->alterTable('xf_mg_album', function (Alter $table) {
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_mg_media_item')) {
            $sm->alterTable('xf_mg_media_item', function (Alter $table) {
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        if ($sm->tableExists('xf_xa_ams_article')) {
            $sm->alterTable('xf_xa_ams_article', function (Alter $table) {
                $table->addColumn('xs_seo_title', 'varchar', 150)->setDefault('');
            });
        }

        $this->changeRoute();
    }

    public function upgrade2060210Step1()
    {
        $this->changeRoute(false, ['threads']);
    }

    public function upgrade2060395Step1()
    {
        $sm = $this->schemaManager();
        $sm->alterTable('xf_node', function (Alter $table) {
            $table->changeColumn('xs_seo_title')->nullable(false)->setDefault('');
        });

        $sm->alterTable('xf_thread', function (Alter $table) {
            $table->changeColumn('xs_seo_title')->nullable(false)->setDefault('');
        });

        $changeRouteFilter = [];

        if ($sm->tableExists('xf_rm_category')) {
            $sm->alterTable('xf_rm_category', function (Alter $table) use ($sm) {
                $this->addOrChangeColumn($table, $sm, 'xf_rm_category');
            });

            $changeRouteFilter[] = 'resources';
        }

        if ($sm->tableExists('xf_rm_resource')) {
            $sm->alterTable('xf_rm_resource', function (Alter $table) use ($sm) {
                $this->addOrChangeColumn($table, $sm, 'xf_rm_resource');
            });
        }

        if ($sm->tableExists('xf_mg_category')) {
            $sm->alterTable('xf_mg_category', function (Alter $table) use ($sm) {
                $this->addOrChangeColumn($table, $sm, 'xf_mg_category');
            });
            $changeRouteFilter[] = 'albums';
        }

        if ($sm->tableExists('xf_mg_album')) {
            $sm->alterTable('xf_mg_album', function (Alter $table) use ($sm) {
                $this->addOrChangeColumn($table, $sm, 'xf_mg_album');
            });
        }

        if ($sm->tableExists('xf_mg_media_item')) {
            $sm->alterTable('xf_mg_media_item', function (Alter $table) use ($sm) {
                $this->addOrChangeColumn($table, $sm, 'xf_mg_media_item');
            });
        }

        if ($sm->tableExists('xf_xa_ams_article')) {
            $sm->alterTable('xf_xa_ams_article', function (Alter $table) use ($sm) {
                $this->addOrChangeColumn($table, $sm, 'xf_xa_ams_article');
            });
        }

        if(count($changeRouteFilter)) {
            $this->changeRoute(false, $changeRouteFilter);
        }
    }

    protected function addOrChangeColumn(Alter $table, SchemaManager $sm, string $tableName)
    {
        if($sm->columnExists($tableName, 'xs_seo_title')) {
            $table->changeColumn('xs_seo_title')->nullable(false)->setDefault('');
        } else {
            $table->addColumn('xs_seo_title', 'varchar', 150)->nullable(false)->setDefault('');
        }
    }

    public function upgrade2060398Step1()
    {
        $sm = $this->schemaManager();
        $sm->alterTable('xf_thread_prefix', function (Alter $table) {
            $table->changeColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
        });

        if ($sm->tableExists('xf_rm_resource_prefix')) {
            $sm->alterTable('xf_rm_resource_prefix', function (Alter $table) use ($sm) {
                if($sm->columnExists('xf_rm_resource_prefix', 'xs_seo_meta_robots')) {
                    $table->changeColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
                } else {
                    $table->addColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
                }
            });
        }
    }

    public function uninstallStep1()
    {
        $sm = $this->schemaManager();
        $sm->alterTable('xf_node', function (Alter $table) {
            $table->dropColumns('xs_seo');
            $table->dropColumns('xs_seo_title');
        });

        $sm->alterTable('xf_thread', function (Alter $table) {
            $table->dropColumns('xs_seo');
            $table->dropColumns('xs_seo_title');
        });

        $sm->alterTable('xf_thread_prefix', function (Alter $table) {
            $table->dropColumns('xs_seo_meta_robots');
        });

        $this->changeRoute(true);
    }

    public function uninstallStep2()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_rm_category')) {
            $sm->alterTable('xf_rm_category', function (Alter $table) {
                $table->dropColumns('xs_seo');
                $table->dropColumns('xs_seo_title');
            });
        }

        if ($sm->tableExists('xf_rm_resource')) {
            $sm->alterTable('xf_rm_resource', function (Alter $table) {
                $table->dropColumns('xs_seo');
                $table->dropColumns('xs_seo_title');
            });
        }

        if ($sm->tableExists('xf_rm_resource_prefix')) {
            $sm->alterTable('xf_rm_resource_prefix', function (Alter $table) {
                $table->dropColumns('xs_seo_meta_robots');
            });
        }
    }

    public function uninstallStep3()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_mg_category')) {
            $sm->alterTable('xf_mg_category', function (Alter $table) {
                $table->dropColumns('xs_seo');
                $table->dropColumns('xs_seo_title');
            });
        }

        if ($sm->tableExists('xf_mg_album')) {
            $sm->alterTable('xf_mg_album', function (Alter $table) {
                $table->dropColumns('xs_seo');
                $table->dropColumns('xs_seo_title');
            });
        }

        if ($sm->tableExists('xf_mg_media_item')) {
            $sm->alterTable('xf_mg_media_item', function (Alter $table) {
                $table->dropColumns('xs_seo');
                $table->dropColumns('xs_seo_title');
            });
        }
    }

    public function uninstallStep4()
    {
        $sm = $this->schemaManager();
        if ($sm->tableExists('xf_xa_ams_article')) {
            $sm->alterTable('xf_xa_ams_article', function (Alter $table) {
                $table->dropColumns('xs_seo');
                $table->dropColumns('xs_seo_title');
            });
        }
    }
}