<?php
namespace XenSoluce\SEOOptimization\SEO;

use XF\Entity\Post;

/**
 * @property \XF\Entity\Thread $entity
 * Class ResourceItem
 * @package XenSoluce\SEOOptimization\SEO
 */
class Thread extends AbstractHandler
{
    protected function changeOpenGraph($default = '')
    {
        $options = \XF::options();
        $defaultImage = $options->xs_seo_open_graph_settings;

        if($defaultImage == 'url' && !empty($options->xs_seo_open_graph_img))
        {
            return $options->xs_seo_open_graph_img;
        }

        if($defaultImage == 'avatar')
        {
            $firstPost = $this->entity->FirstPost;
            if(!empty($firstPost->User) && $firstPost->User instanceof \XF\Entity\User)
            {
                $avatarUrl = $firstPost->User->getAvatarUrl('h', '', true);
                if($avatarUrl)
                {
                    return $avatarUrl;
                }
            }
        }

        if($defaultImage == 'attachment')
        {
            $firstPost = $this->entity->FirstPost;
            if($firstPost == null)
            {
                return $default;
            }
            $imageAttachment = $firstPost->Attachments;
            $canViewAttachment = $this->entity->canViewAttachments();

            return $this->getAttachment($imageAttachment, $default, $canViewAttachment);
        }

        if(!empty($this->entity->Forum->Node->xs_seo['open_graph'])) {
            return $this->entity->Forum->Node->xs_seo['open_graph'];
        }

        return $default;
    }

    protected function option(): array
    {
        return [
            'separator' => \XF::options()->xs_seo_symbol_separator,
            'metaTitle' => \XF::options()->xs_seo_threads_meta_title,
            'metaDesc' => \XF::options()->xs_seo_threads_meta_desc
        ];
    }

    protected function description(): string
    {
        if (isset($this->entity->FirstPost->message))
        {
            return $this->entity->FirstPost->message;
        }

        /** @var Post $firstPost */
        $firstPost = \XF::app()->em()->getFinder('XF:Post')
            ->where('thread_id', $this->entity->thread_id)
            ->fetchOne();

        return $firstPost->message ?? \XF::options()->boardDescription;
    }

    public function changeTitle($escape, array $entityOption = []): ?string
    {
        $escape = true;
        $boardTitle = $this->boardTitleLength($this->entity->title);

        if (isset($this->entity->title) && strlen($this->entity->title))
        {
            $forumTitle = '';

            if(!empty($this->entity->Forum->title))
            {
                $forumTitle = $this->entity->Forum->title;
            }

            $prefixTitle = $this->templater->fnPrefix(
                $this->templater,
                $escape,
                'thread',
                $this->entity,
                'plain',
                ''
            );

            $newThreadTitle = $this->entity->title . ' | ' . $boardTitle;

            $newThreadTitleFormat = !empty($this->entity->xs_seo['meta_title'])
                ? $this->entity->xs_seo['meta_title']
                : $this->optionSEO->metaTitle;

            if(!empty($newThreadTitleFormat))
            {
                $separator = $this->optionSEO->separator;
                $newThreadTitleFormat = preg_replace('/(%)\s(%)/', '$1$2', $newThreadTitleFormat);
                $titleSegments = @explode('%', $newThreadTitleFormat);

                if($titleSegments)
                {
                    $segmentsArray = [
                        'thread_title' => $this->entity->title,
                        'prefix_title' => $prefixTitle,
                        'forum_title' => $forumTitle,
                        'board_title' => $boardTitle,
                        'page_number' => $entityOption['pageNum'],
                    ];

                    $titleSegments = str_replace(array_keys($segmentsArray), array_values($segmentsArray), $titleSegments);
                    $titleSegments = array_filter($titleSegments);
                    if($separator == 'none')
                    {
                        $newThreadTitle = implode(" ", $titleSegments);
                    }
                    else
                    {
                        $newThreadTitle = implode(" $separator ", $titleSegments);
                    }
                }
            }

            return $this->templater->escape($newThreadTitle, $escape);
        }

        return sprintf('%s | %s',
            $this->templater->escape($this->entity->title . $entityOption['pageNum'], $escape),
            $this->templater->escape($boardTitle, $escape)
        );
    }

    public function changeDescription(&$escape)
    {
        $escape = true;
        if($this->optionSEO->metaDesc)
        {
            $forumTitle = '';
            if(!empty($this->entity->Forum->title))
            {
                $forumTitle = $this->entity->Forum->title;
            }

            $prefixTitle = $this->templater->fnPrefix(
                $this->templater,
                $escape,
                'thread',
                $this->entity,
                'plain',
                ''
            );

            $threadDesc = preg_replace('/(%)\s(%)/', '$1$2', $this->optionSEO->metaDesc);
            $descSegments = @explode('%', $threadDesc);

            if($descSegments)
            {
                $segmentsArray = [
                    'thread_title' => $this->entity->title,
                    'prefix_title' => $prefixTitle,
                    'forum_title' => $forumTitle,
                    'board_title' => \XF::options()->boardTitle,
                ];

                $descSegments = str_replace(array_keys($segmentsArray), array_values($segmentsArray), $descSegments);
                $descSegments = array_filter($descSegments);
                $threadDesc = implode("", $descSegments);
            }

            return $threadDesc;
        }
        else
        {
            return parent::changeDescription($escape);
        }
    }
}