<?php
namespace XenSoluce\SEOOptimization\SEO;

use XF\Mvc\Entity\Entity;
use XF\Template\Templater;

/**
 * @property \XF\Entity\Node $entity
 * Class ResourceItem
 * @package XenSoluce\SEOOptimization\SEO
 */
class Node extends AbstractHandler
{
    protected function changeOpenGraph($default = '')
    {
        return $default;
    }

    protected function option(): array
    {
        return [
            'separator' => \XF::options()->xs_seo_album_separator,
            'metaTitle' => \XF::options()->xs_seo_categories_meta_title,
            'metaDesc' => \XF::options()->xs_seo_categories_meta_desc
        ];
    }

    protected function description(): string
    {
        return $this->entity->description;
    }

    public function changeTitle($escape, array $entityOption = []): ?string
    {
        if(!empty($this->entity->xs_seo['meta_title']))
        {
            return $this->templater->escape($this->entity->xs_seo['meta_title'], $escape);
        }

        if (isset($this->entity->title) && strlen($this->entity->title))
        {
            $parentTitle = '';

            if($this->entity->depth)
            {
                $parentTitle = $this->entity->Parent->title;
            }

            $newCategoryTitle = $this->entity->title . ' | ' . \XF::options()->boardTitle;
            $newCategoryTitleFormat = $this->optionSEO->metaTitle;

            if(!empty($newCategoryTitleFormat))
            {
                $separator = $this->optionSEO->separator;
                $newCategoryTitleFormat = preg_replace('/(%)\s(%)/', '$1$2', $newCategoryTitleFormat);
                $titleSegments = @explode('%', $newCategoryTitleFormat);

                if($titleSegments)
                {
                    $segmentsArray = [
                        'parent_node' => $parentTitle,
                        'forum_title' => $this->entity->title,
                        'board_title' => \XF::options()->boardTitle,
                        'page_number' => $entityOption['pageNum'],
                    ];

                    $titleSegments = str_replace(array_keys($segmentsArray), array_values($segmentsArray), $titleSegments);
                    $titleSegments = array_filter($titleSegments);
                    if($separator == 'none')
                    {
                        $newCategoryTitle = implode(" ", $titleSegments);
                    }
                    else
                    {
                        $newCategoryTitle = implode(" $separator ", $titleSegments);
                    }
                }
            }

            return $this->templater->escape($newCategoryTitle, $escape);
        }

        return sprintf('%s | %s',
            $this->templater->escape($this->entity->title . $entityOption['pageNum'], $escape),
            $this->templater->escape(\XF::options()->boardTitle, $escape)
        );
    }

    public function changeDescription(&$escape)
    {
        if($this->optionSEO->metaDesc)
        {
            $forumDesc = preg_replace('/(%)\s(%)/', '$1$2', $this->optionSEO->metaDesc);
            $descSegments = @explode('%', $forumDesc);

            if($descSegments)
            {
                $segmentsArray = [
                    'forum_title' => $this->entity->title,
                    'board_title' => \XF::options()->boardTitle,
                ];

                $descSegments = str_replace(array_keys($segmentsArray), array_values($segmentsArray), $descSegments);
                $descSegments = array_filter($descSegments);
                $forumDesc = implode("", $descSegments);
            }

            return $forumDesc;
        }
        else
        {
            return false;
        }
    }
}