<?php
namespace XenSoluce\SEOOptimization\SEO;

use XF\Mvc\Entity\Entity;
use XF\Template\Templater;

/**
 * @property \XenAddons\AMS\Entity\ArticleItem $entity
 * Class ResourceItem
 * @package XenSoluce\SEOOptimization\SEO
 */
class ArticleItem extends AbstractHandler
{
    protected string $nameItemTitle = 'ams_article';
    protected string $nameItemDescription = 'ams_article';

    protected function changeOpenGraph($default = '')
    {
        $options = \XF::options();

        $defaultImage = $options->xs_seo_open_graph_settings;

        if($defaultImage == 'url' && !empty($options->xs_seo_open_graph_img))
        {
            return $options->xs_seo_open_graph_img;
        }

        if($defaultImage == 'avatar')
        {
            return $this->getAvatarUrl($default);
        }

        return $default;
    }

    protected function option(): array
    {
        return [
            'separator' => \XF::options()->xs_seo_ams_separator,
            'metaTitle' => \XF::options()->xs_seo_ams_meta_title,
            'metaDesc' => ''
        ];
    }

    protected function description(): string
    {
        return '';
    }
}