<?php

namespace XenSoluce\SEOOptimization\Repository;

use XF\Mvc\Entity\Repository;

class SEOOptimization extends Repository
{
    public function getSEOHandler($type, $throw = false)
    {
        $handlerClass = \XF::app()->getContentTypeFieldValue($type, 'xs_seo_handler');
        if (!$handlerClass)
        {
            if ($throw)
            {
                throw new \InvalidArgumentException("No SEO handler for '$type'");
            }
            return null;
        }

        if (!class_exists($handlerClass))
        {
            if ($throw)
            {
                throw new \InvalidArgumentException("SEO handler for '$type' does not exist: $handlerClass");
            }
            return null;
        }

        $handlerClass = \XF::extendClass($handlerClass);

        return new $handlerClass($type);
    }
}