<?php

namespace XenGenTr\XGTOnekTasarimlari\XFRM\Admin\Controller;

use XF\Mvc\Reply\View;
use XF\Entity\AbstractPrefix;
use XenGenTr\XGTOnekTasarimlari\Repository\OnekTasarim;

class ResourcePrefix extends XFCP_ResourcePrefix
{
    protected function prefixAddEditResponse(AbstractPrefix $prefix)
    {
        $response = parent::prefixAddEditResponse($prefix);

        if ($response instanceof View) {
            $oneks = $this->repository('XenGenTr\XGTOnekTasarimlari:OnekTasarim')->getAllOnekTasarimlar();
            
            $displayStyles = $response->getParam('displayStyles');

            foreach ($oneks as $onek) {
                $prefix_name = 'xgt_onek_tasarim :' . $onek->onek_id;
                array_push($displayStyles, $prefix_name);
            }
            
            $response->setParam('displayStyles', $displayStyles);

            $response->setParam('oneks', $oneks);
        }

        return $response;
    }
}
