<?php

namespace XenGenTr\XGTOnekTasarimlari;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;
use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

class Setup extends AbstractSetup
{
    use StepRunnerInstallTrait;
    use StepRunnerUpgradeTrait;
    use StepRunnerUninstallTrait;

    /**
     * Kuruluma basla
     */
    public function installStep1()
    {
        $this->schemaManager()->createTable('xgt_onek_tasarim', function (Create $table) {
            $table->addColumn('onek_id', 'int')->autoIncrement();
            $table->addColumn('onek_adi', 'varchar', 100)->setDefault('');
            $table->addColumn('onek_ikonu', 'varchar', 100)->setDefault('');
            $table->addColumn('onek_renk', 'varchar', 50)->setDefault('');
            $table->addColumn('onek_metin', 'varchar', 50)->setDefault('');
            $table->addPrimaryKey('onek_id');
        });
    }

    /**
     * Kurulumu temizle
     */
    public function uninstallStep1()
    {
        $this->schemaManager()->dropTable('xgt_onek_tasarim');
    }
}
