<?php

namespace XenGenTr\XGTOnekTasarimlari\Entity;

use XF\Mvc\Entity\Structure;
use XF\Mvc\Entity\Entity;

class OnekTasarim extends Entity
{
    public static function getStructure(Structure $structure)
    {
        $structure->table = 'xgt_onek_tasarim'; 
        $structure->shortName = 'XenGenTr\XGTOnekTasarimlari:OnekTasarim';
        $structure->primaryKey = 'onek_id';
        $structure->columns = [
            'onek_id' => ['type' => self::UINT, 'autoIncrement' => true],
            'onek_adi' => [
                'type' => self::STR,
                'required' => true,
                'maxLength' => 255,
                'api' => true,
            ],
            'onek_ikonu' => ['type' => self::STR, 'required' => true, 'maxLength' => 100],
            'onek_renk' => ['type' => self::STR, 'required' => true, 'maxLength' => 20],
            'onek_metin' => ['type' => self::STR, 'required' => true, 'maxLength' => 255]
        ];

        return $structure;
    }
}
