<?php

namespace XenGenTr\XGTForumistatistik\Widget;

use XF\Repository\FeaturedContentRepository;

class OneCikanlar extends AbstractForumIstatistik
{

    public function render()
    {
        $limit = \XF::options()->xgtIstatistikGosterimLimiti;

        $contentType = $this->options['content_type'];

        $featureRepo = $this->getFeatureRepo();
        $finder = $featureRepo->findFeaturedContent();

        $features = $finder->fetch(max($limit * 2, 10));

        $total = $features->count();
        $features = $features->slice(0, $limit, true);
        $hasMore = $total > $features->count();

        $router = $this->app->router('public');
        $linkParams = [];

        if ($contentType) {
            $linkParams['content_type'] = $contentType;
        }

        $link = $router->buildLink('featured', null, $linkParams);

        $viewParams = [
            'features' => $features,
        ];

		return $this->renderer('xgt_forum_istatistik_onecikanlar', $viewParams);
    }

    protected function getFeatureRepo(): FeaturedContentRepository
    {
        return $this->repository(FeaturedContentRepository::class);
    }
}
