<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Repository;


class Thread extends XFCP_Thread
{
    // ################ THREAD READERS ################

    public function findThreadReadersByThreadId($threadId, $userId)
    {
        $session = \XF::session();
        if (!empty($session['robot']))
        {
            return '';
        }

        $finder = $this->finder('XF:ThreadRead');

        $finder
            ->with('User')
            ->where('thread_id', $threadId)
            ->where('user_id', '!=', $userId);

        $options = \XF::options();

        if ($options->xc_user_activity_exclude_user_banned)
        {
            $finder->where('User.is_banned', false);
        }

        if ($options->xc_user_activity_readers_sort_by_alphabetical)
        {
            $finder->order('User.username', 'ASC');
        }
        else
        {
            $finder->order('thread_read_date', 'DESC');
        }

        if ($options->xc_user_activity_display_days)
        {
            $displayDays = $options->xc_user_activity_display_days;
            $displayDays = \XF::$time - $displayDays * 86400;

            $finder->where('thread_read_date', '>', $displayDays);
        }

        return $finder;
    }

    // ################ THREAD REPLIES ################

    public function findThreadRepliesByThreadId($threadId, $userId)
    {
        $finder  = $this->finder('XF:ThreadUserPost');
        $options = \XF::options();

        $finder
            ->with('User')
            ->where('user_id', '!=', $userId)
            ->where('thread_id', $threadId);

        if ($options->xc_user_activity_exclude_user_banned_replied)
        {
            $finder->where('User.is_banned', false);
        }

        if ($options->xc_user_activity_replies_sort_by_alphabetical)
        {
            $finder->order('User.username', 'ASC');
        }

        return $finder;
    }
}