<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Entity;

use XF\Mvc\Entity\Structure;

/**
 * GETTERS
 * @property array post_user_ids
 */
class Thread extends XFCP_Thread
{

    public function canViewThreadViewers(&$error = null)
    {
        $visitor = \XF::visitor();

        if (!$visitor->user_id)
        {
            return $visitor->hasNodePermission($this->node_id,'viewersAllThread');
        }

        if ($visitor->user_id === $this->user_id)
        {
            return $visitor->hasNodePermission($this->node_id,'viewersOwnThread');
        }
        else
        {
            return $visitor->hasNodePermission($this->node_id,'viewersAllThread');
        }
    }

    public function canViewThreadReplies(&$error = null)
    {
        $visitor = \XF::visitor();

        if (!$visitor->user_id)
        {
            return $visitor->hasNodePermission($this->node_id,'repliesAllThread');
        }

        if ($visitor->user_id === $this->user_id)
        {
            return $visitor->hasNodePermission($this->node_id,'repliesOwnThread');
        }
        else
        {
            return $visitor->hasNodePermission($this->node_id,'repliesAllThread');
        }
    }

    public function canViewThreadReaders(&$error = null)
    {
        $visitor = \XF::visitor();

        if (!$visitor->user_id)
        {
            return $visitor->hasNodePermission($this->node_id,'readersAllThread');
        }

        if ($visitor->user_id === $this->user_id)
        {
            return $visitor->hasNodePermission($this->node_id,'readersOwnThread');
        }
        else
        {
            return $visitor->hasNodePermission($this->node_id,'readersAllThread');
        }
    }

    public function getPostUserIds()
    {
        $options = $this->app()->options();

        $order = 'post.post_date DESC';

        if ($options->xc_user_activity_readers_sort_by_alphabetical)
        {
            $order = 'user.username ASC';
        }

        $whereClause = '';

        if ($options->xc_user_activity_exclude_user_banned_replied)
        {
            $whereClause = 'AND user.is_banned = 0';
        }

        return $this->db()->fetchAllKeyed("
			SELECT post.user_id, post.thread_id, post.post_date, user.*
			FROM xf_post AS post
			LEFT JOIN xf_user AS user ON (post.user_id = user.user_id)
			WHERE post.thread_id = ? 
			AND post.user_id != ?
			{$whereClause}
			ORDER BY {$order}
		", 'user_id', [$this->thread_id, $this->user_id]);
    }

    public static function getStructure(Structure $structure)
    {
        $structure = parent::getStructure($structure);

        $structure->getters['post_user_ids'] = true;

        return $structure;
    }

}