<?php
/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2019
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\Widget;

use XF\Widget\AbstractWidget;

class ProjectViewers extends AbstractWidget
{
    protected $projectId;

    public function render()
    {
        $session = \XF::session();
        if (!empty($session['robot']))
        {
            return '';
        }

        $this->projectId = $this->contextParams['project']->project_id;
        $viewersParams  = $this->runAndGetResult();

        $userCount   = $viewersParams['userCount'];
        $guestCount  = $viewersParams['guestCount'];
        $userViewers = $viewersParams['userViewers'];


        $title = \XF::phrase('xc_user_activity_users_who_are_viewing_this_project_total_x_members_x_guests_x',
            [
                'total'       => $userCount + $guestCount,
                'totalMember' => $userCount,
                'totalGuest'  => $guestCount
            ]
        );

        $options = \XF::options();

        $viewParams = [
            'title'         => $title,
            'userViewers'   => $userViewers,
            'removeFooter'  => false,//$options->xc_user_activity_viewing_thread_remove_footer,
            'userDisplay'   => $options->xc_user_activity_display_users_viewing_project,
            'currentUser'   => $viewersParams['currentUser']
        ];
        return $this->renderer('xc_user_activity_project_viewers_widget', $viewParams);
    }

    protected function runAndGetResult()
    {
        $nodeSessionActivityRepo = $this->getNodeSessionActivityRepo();
        $projectViewersFinder = $nodeSessionActivityRepo->findUserNodeSessionActivityForXViewers()
            ->where('content_type', 'project')
            ->where('content_id', $this->projectId);

        $user = \XF::visitor();
        if ($user->user_id)
        {
            $projectViewersFinder
                ->where('user_id', '!=', $user->user_id);
        }

        $projectViewers = $projectViewersFinder->fetch();
        $userCount = $projectViewers->count();

        if ($user->user_id)
        {
            $userCount++;
        }

        $guestCount = $nodeSessionActivityRepo->countUserNodeSessionActivityForXViewers(null,'project', $this->projectId);

        return [
            'userViewers'  => $projectViewers,
            'userCount'    => $userCount,
            'guestCount'   => $guestCount,
            'currentUser'  => $user
        ];
    }

    /**
     * @return \XenConcept\UserActivity\Repository\NodeSessionActivity|\XF\Mvc\Entity\Repository
     */
    protected function getNodeSessionActivityRepo()
    {
        return $this->repository('XenConcept\UserActivity:NodeSessionActivity');
    }

    /**
     * @return string|null
     */
    public function getOptionsTemplate()
    {
        return 'admin:xc_user_activity_widget_def_options_' . $this->widgetConfig->definitionId;
    }
}