<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\Listener;

use XF\Container;
use XF\Pub\App;

class Listener
{
    public static function optionTabbed(\XF\Template\Templater $templater, &$type, &$template, &$name, array &$arguments, array &$globalVars)
    {
        if (isset($arguments['group']) && $arguments['group']->group_id == 'xc_user_activity')
        {
            // Override template name
            $template = 'xc_user_activity_option_tabbed_macros';
        }
    }

    public static function templaterPreRender(\XF\Template\Templater $templater, &$type, &$template, array &$params)
    {

        if (isset($params['groups']['xc_user_activity']))
        {
            $template = 'xc_user_activity_addon_option_tabbed_macros';
        }
    }

    public static function appSetup(\XF\App $app)
    {
        $cache = $app->cache();

      // \XF::dump($cache);





        if ($app instanceof App)
        {
            $container = $app->container();
            $forumViewers = self::getNodeSessionActivityRepo()->countUserNodeSessionActivityForForumListViewers();

            $container['xcUANode'] = function (Container $c) use ($forumViewers)
            {
                return empty($forumViewers) ? [] : $forumViewers;
            };
        }
    }

    /**
     * @return \XenConcept\UserActivity\Repository\NodeSessionActivity|\XF\Mvc\Entity\Repository
     */
    protected static function getNodeSessionActivityRepo()
    {
        return \XF::app()->repository('XenConcept\UserActivity:NodeSessionActivity');
    }
}