<?php

namespace XenBulletins\Core;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;
use XF\Db\Schema\Alter;
class Setup extends AbstractSetup {

    use StepRunnerInstallTrait;
    use StepRunnerUpgradeTrait;
    use StepRunnerUninstallTrait;

    public function installStep1() {
        $this->schemaManager()->alterTable(
                'xf_api_key', function (Alter $table) {
            $table->addColumn('xf_license', 'int')->setDefault(0);
        }
        );
    }

    /* ALTER xf_user */

    public function uninstallStep1() {
        $this->schemaManager()->alterTable(
                'xf_api_key', function (Alter $table) {
            $table->dropColumns([
                'xf_license'
            ]);
        }
        );
    }

}
