<?php

namespace XP\VB\XF\Searcher;

use XF\Mvc\Entity\Finder;

class User extends XFCP_User
{
	public function applySpecialCriteriaValue(Finder $finder, $key, $value, $column, $format, $relation)
	{
		if ($key == 'xp_vb_verification_badge')
		{
			if ($value == 0)
			{
				$finder->where('xp_vb_is_verified', '=', '0');
			}
			elseif ($value == 1)
			{
				$finder->where('xp_vb_is_verified', '=', '1');
			}
		}
		elseif ($key == 'xp_vb_verificationrequest_count' && !empty($value['start']))
		{
			$finder->where('xp_vb_verificationrequest_count', '>=', $value['start']);
		}
		elseif ($key == 'xp_vb_verificationrequest_count' && !empty($value['end']))
		{
			$finder->where('xp_vb_verificationrequest_count', '<=', $value['end']);
		}

		return parent::applySpecialCriteriaValue($finder, $key, $value, $column, $format, $relation);
	}

	public function getFormDefaults()
	{
		$defaults = parent::getFormDefaults();

		$defaults['xp_vb_verification_badge'] = [0, 1];

		return $defaults;
	}
}