<?php

namespace XP\VB\XF\Job;

class UserAction extends XFCP_UserAction
{
	protected function applyInternalUserChange(\XF\Entity\User $user)
	{
		parent::applyInternalUserChange($user);

		/** @var \XP\VB\XF\Entity\User $user */

		$setVerified = $this->getActionValue('xp_vb_add_verification');
		if ($setVerified)
		{
			$user->xp_vb_is_verified = true;

			$phrase = $this->getActionValue('xp_vb_tooltip_phrase');
			$user->xp_vb_tooltip_phrase = $phrase ?: '';
		}

		$removeVerified = $this->getActionValue('xp_vb_remove_verification');
		if ($removeVerified)
		{
			$user->xp_vb_is_verified = false;
		}
	}
}