<?php

namespace XP\VB\XF\Entity;

use XP\VB\Entity\Request;

/**
 * COLUMNS
 * @property bool $xp_vb_is_verified
 * @property int $xp_vb_verificationrequest_count
 * @property string $xp_vb_tooltip_phrase
 *
 * RELATIONS
 * @property Request[] $Request
 *
 * */
class User extends XFCP_User
{
	public function getVbPhrase()
	{
		if (!empty($this->xp_vb_tooltip_phrase))
		{
			return htmlspecialchars(strtr($this->xp_vb_tooltip_phrase, [
				'{user_id}' => $this->user_id,
				'{username}' => $this->username,
			]));
		}

		return \XF::phrase('xp_vb_tooltip', [
			'username' => $this->username,
			'user_id' => $this->user_id,
		]);
	}

	public function hasVbRequestPermission($permission)
	{
		return $this->hasPermission('xp_vb', $permission);
	}

	public function canRequestVb(&$error = null)
	{
		/** @var \XP\VB\XF\Entity\User $visitor */
		$visitor = \XF::visitor();
		if (!$visitor->user_id)
		{
			return false;
		}

		if ($this->hasPermission('xp_vb', 'request'))
		{
			$maxRequestCount = $this->hasPermission('xp_vb', 'maxRequestCount');
			$userRequestCount = $visitor->xp_vb_verificationrequest_count;

			if ($maxRequestCount == -1 || $maxRequestCount == 0) // unlimited NOTE: in this particular case, we want 0 to count as unlimited.
			{
				return true;
			}

			if ($userRequestCount < $maxRequestCount)
			{
				return true;
			}

			return false;
		}

		return $this->hasPermission('xp_vb', 'request');
	}

	public function getNewVbRequest()
	{
		/** @var Request $request */
		$request = $this->_em->create('XP\VB:Request');
		$request->user_id = $this->user_id;

		return $request;
	}

	public function userRequestedVb(Request $request)
	{
		$this->request_date = $request->approve_date;
		$this->request_id = $request->request_id;
		$this->user_id = $request->user_id;
		$this->username = $request->username;

	}
}