<?php

namespace XP\VB;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;
use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

class Setup extends AbstractSetup
{
	use StepRunnerInstallTrait;
	use StepRunnerUpgradeTrait;
	use StepRunnerUninstallTrait;

	// ################################## INSTALL ###########################################

	public function installStep1()
	{
		$sm = $this->schemaManager();
		foreach ($this->getTables() as $tableName => $callback)
		{
			$sm->createTable($tableName, $callback);
		}
	}

	public function installStep2()
	{
		$sm = $this->schemaManager();
		foreach ($this->getAlters() as $table => $schema)
		{
			if ($sm->tableExists($table))
			{
				$sm->alterTable($table, $schema);
			}
		}
	}

	// ################################## UNINSTALL ###########################################

	public function uninstallStep1()
	{
		$sm = $this->schemaManager();

		foreach (array_keys($this->getTables()) as $tableName)
		{
			$sm->dropTable($tableName);
		}
	}

	public function uninstallStep2()
	{
		$sm = $this->schemaManager();
		foreach ($this->getReverseAlters() as $table => $schema)
		{
			if ($sm->tableExists($table))
			{
				$sm->alterTable($table, $schema);
			}
		}
	}

	public function uninstallStep3()
	{
		$this->uninstallContentTypeData(['vb_request']);
	}

	// ################################## UPGRADE ###########################################

	public function upgrade2020171Step1()
	{
		$sm = $this->schemaManager();

		$sm->alterTable('xf_user', function (Alter $table) {
			$table->addColumn('xp_vb_tooltip_phrase', 'varchar', 255)->nullable()->setDefault(null);
		});
	}

	public function upgrade2020500Step1()
	{
		$sm = $this->schemaManager();

		$sm->alterTable('xf_xp_vb_request', function (Alter $table) {
			$table->addColumn('custom_fields', 'mediumblob')->nullable()->setDefault(null)->after('embed_metadata');
		});

		$sm->createTable('xf_xp_vb_request_field', function (Create $table) {
			$table->addColumn('field_id', 'varbinary', 25);
			$table->addColumn('display_group', 'varchar', 25)->setDefault('above_message');
			$table->addColumn('display_order', 'int')->setDefault(1);
			$table->addColumn('field_type', 'varbinary', 25)->setDefault('textbox');
			$table->addColumn('field_choices', 'blob');
			$table->addColumn('match_type', 'varbinary', 25)->setDefault('none');
			$table->addColumn('match_params', 'blob');
			$table->addColumn('max_length', 'int')->setDefault(0);
			$table->addColumn('required', 'tinyint')->setDefault(0);
			$table->addColumn('display_template', 'text');
			$table->addColumn('wrapper_template', 'text');
			$table->addPrimaryKey('field_id');
			$table->addKey(['display_group', 'display_order'], 'display_group_order');
		});

		$sm->createTable('xf_xp_vb_request_field_value', function (Create $table) {
			$table->addColumn('request_id', 'int');
			$table->addColumn('field_id', 'varbinary', 25);
			$table->addColumn('field_value', 'mediumtext');
			$table->addPrimaryKey(['request_id', 'field_id']);
			$table->addKey('request_id');
		});
	}

	// ################################## DATA ###########################################

	/**
	 * @return array
	 */
	protected function getTables(): array
	{
		$tables = [];

		$tables['xf_xp_vb_request'] = function (Create $table) {
			$table->addColumn('request_id', 'int')->autoIncrement();
			$table->addColumn('user_id', 'int');
			$table->addColumn('username', 'varchar', 50)->setDefault('');
			$table->addColumn('request_date', 'int')->setDefault(0);
			$table->addColumn('edit_date', 'int')->setDefault(0);
			$table->addColumn('approve_date', 'int')->setDefault(0);
			$table->addColumn('reject_date', 'int')->setDefault(0);
			$table->addColumn('close_date', 'int')->setDefault(0);
			$table->addColumn('request_status', 'enum')->values(['pending', 'approved', 'rejected', 'closed'])->setDefault('pending');
			$table->addColumn('message', 'mediumtext');
			$table->addColumn('status_message', 'mediumtext');
			$table->addColumn('attach_count', 'int')->setDefault(0);
			$table->addColumn('ip_id', 'int')->setDefault(0);
			$table->addColumn('embed_metadata', 'blob')->nullable();
			$table->addColumn('custom_fields', 'mediumblob')->nullable()->setDefault(null);

			$table->addKey(['request_id', 'request_date'], 'request_id_request_date');
			$table->addKey('user_id');
			$table->addKey('request_date');
			$table->addKey('request_status');
		};

		$tables['xf_xp_vb_request_field'] = function ($table) {
			$table->addColumn('field_id', 'varbinary', 25);
			$table->addColumn('display_group', 'varchar', 25)->setDefault('above_message');
			$table->addColumn('display_order', 'int')->setDefault(1);
			$table->addColumn('field_type', 'varbinary', 25)->setDefault('textbox');
			$table->addColumn('field_choices', 'blob');
			$table->addColumn('match_type', 'varbinary', 25)->setDefault('none');
			$table->addColumn('match_params', 'blob');
			$table->addColumn('max_length', 'int')->setDefault(0);
			$table->addColumn('required', 'tinyint')->setDefault(0);
			$table->addColumn('display_template', 'text');
			$table->addColumn('wrapper_template', 'text');
			$table->addPrimaryKey('field_id');
			$table->addKey(['display_group', 'display_order'], 'display_group_order');
		};

		$tables['xf_xp_vb_request_field_value'] = function ($table) {
			$table->addColumn('request_id', 'int');
			$table->addColumn('field_id', 'varbinary', 25);
			$table->addColumn('field_value', 'mediumtext');
			$table->addPrimaryKey(['request_id', 'field_id']);
			$table->addKey('request_id');
		};

		return $tables;
	}

	/**
	 * @return array
	 */
	protected function getAlters()
	{
		$alters = [];

		$alters['xf_user'] = function (Alter $table) {
			$table->addColumn('xp_vb_is_verified', 'tinyint', 1)->setDefault(0);
			$table->addColumn('xp_vb_verificationrequest_count', 'int')->setDefault(0);
			$table->addColumn('xp_vb_tooltip_phrase', 'varchar', 255)->nullable()->setDefault(null);
			$table->addKey('xp_vb_verificationrequest_count');
		};

		return $alters;
	}

	/**
	 * @return array
	 */
	protected function getReverseAlters()
	{
		$alters = [];

		$alters['xf_user'] = function (Alter $table) {
			$table->dropColumns([
				'xp_vb_is_verified',
				'xp_vb_verificationrequest_count',
				'xp_vb_tooltip_phrase'
			]);
		};

		return $alters;
	}
}