<?php

namespace XP\VB;

use XF\Container;
use XF\Db\Exception;
use XF\Mvc\Entity\Entity;

class Listener
{
	protected static $_productId = 30;

	/**
	 * @throws Exception
	 */
	public static function appSetup(\XF\App $app)
	{
		/*XP_BRANDING_START*/
		if (!$app->offsetExists('xp_branding_free'))
		{
			// Make sure we fetch the branding array from the application
			$branding = $app->offsetExists('xp_branding') ? $app->xp_branding : [];

			// Add productid to the array
			$branding[] = self::$_productId;

			// Store the branding
			$app->xp_branding = $branding;
		}

		$container = $app->container();

		$container['customFields.xp_vb_request'] = $app->fromRegistry('xpVbRequestFields',
			function (Container $c) {
				return $c['em']->getRepository('XP\VB:RequestField')->rebuildFieldCache();
			},
			function (array $fields) use ($app) {
				$class = $app->extendClass('XF\CustomField\DefinitionSet');

				return new $class($fields);
			}
		);

		/*XP_BRANDING_END*/
	}

	public static function criteriaUser($rule, array $data, \XF\Entity\User $user, &$returnValue)
	{
		switch ($rule)
		{
			case 'xp_vb_is_verified':
				if (isset($user->xp_vb_is_verified) && $user->xp_vb_is_verified == 1)
				{
					$returnValue = true;
				}
				break;
			case 'xp_vb_is_verified_no':
				if (!isset($user->xp_vb_is_verified) || $user->xp_vb_is_verified == 0)
				{
					$returnValue = true;
				}
				break;
			case 'xp_vb_verificationrequest_count':
				if (isset($user->xp_vb_verificationrequest_count) && $user->xp_vb_verificationrequest_count >= $data['vb_request'])
				{
					$returnValue = true;
				}
				break;
			case 'xp_vb_verificationrequest_count_nmt':
				if (isset($user->xp_vb_verificationrequest_count) && $user->xp_vb_verificationrequest_count <= $data['vb_request'])
				{
					$returnValue = true;
				}
				break;
		}
	}

	/**
	 * @return \XP\VB\XF\Entity\User
	 */
	public static function visitor()
	{
		/** @var \XP\VB\XF\Entity\User $visitor */
		$visitor = \XF::visitor();
		return $visitor;
	}

	/**
	 * Allows direct modification of the Entity structure.
	 *
	 * Event hint: Fully qualified name of the root class that was called.
	 *
	 * @param \XF\Mvc\Entity\Manager $em Entity Manager object.
	 * @param \XF\Mvc\Entity\Structure $structure Entity Structure object.
	 */
	public static function userEntityStructure(\XF\Mvc\Entity\Manager $em, \XF\Mvc\Entity\Structure &$structure)
	{
		$structure->columns['xp_vb_is_verified'] = ['type' => Entity::BOOL, 'default' => 0];
		$structure->columns['xp_vb_verificationrequest_count'] = ['type' => Entity::UINT, 'default' => 0, 'forced' => true, 'changeLog' => false];
		$structure->columns['xp_vb_tooltip_phrase'] = ['type' => Entity::STR, 'default' => null, 'changeLog' => true, 'maxLength' => 255];
	}

}