<?php

namespace XP\VB\Entity;

use XF\Mvc\Entity\Structure;

/**
 * COLUMNS
 * @property int $request_id
 * @property string $field_id
 * @property string $field_value
 */
class RequestFieldValue extends \XF\Mvc\Entity\Entity
{
	public static function getStructure(Structure $structure)
	{
		$structure->table = 'xf_xp_vb_request_field_value';
		$structure->shortName = 'XP\VB:RequestFieldValue';
		$structure->primaryKey = ['request_id', 'field_id'];
		$structure->columns = [
			'request_id' => ['type' => self::UINT, 'required' => true],
			'field_id' => ['type' => self::STR, 'maxLength' => 25,
				'match' => 'alphanumeric'
			],
			'field_value' => ['type' => self::STR, 'default' => '']
		];
		$structure->getters = [];
		$structure->relations = [];

		return $structure;
	}
}