<?php
namespace AwesomeForo\AwesomeCore;

use XF\AddOn\AbstractSetup AS XFAbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;

abstract class AwesomeSetup extends XFAbstractSetup
{

	use StepRunnerInstallTrait;
	use StepRunnerUpgradeTrait;
	use StepRunnerUninstallTrait;

	protected $addOnID;
	/**
	 * Perform additional requirement checks.
	 *
	 * @param array $errors Errors will block the setup from continuing
	 * @param array $warnings Warnings will be displayed but allow the user to continue setup
	 *
	 * @return void
	 */
	public function checkRequirements(&$errors = [], &$warnings = [])
	{
		$this->repairToInstall(); 
	}

	public function installStep1()
	{
		$sm = $this->schemaManager();
		//Create Table if needed 
		foreach ($this->getTables() AS $tableName => $closure)
		{
			$sm->createTable($tableName, $closure);
		}
		// Alter Table if needed
		foreach ($this->getAlters() AS $tableName => $closure)
		{
			$sm->alterTable($tableName, $closure);
		}
		$this->doAddDefaultListenerChecker(); 
	}

	public function installStep2()
	{
		//return install step 2 if needed
	}

	public function uninstallStep1()
	{
		$this->repairToUninstall();
		$sm = $this->schemaManager();

		foreach (array_keys($this->getTables()) AS $tableName)
		{
			$sm->dropTable($tableName);
		}
		foreach ($this->getDropAlters() AS $tableName => $closure)
		{
			$sm->alterTable($tableName, $closure);
		}

	}

	public function uninstallStep2()
	{
		//return uninstall step 2 if needed
	}

	public function repairToInstall()
	{
		$this->getAwesomeAddonRepo()->docheckLicense($this->addOnID, $this->addOn->version_id, $this->addOn->addon_id);
	} 

	public function repairToUninstall()
	{
		$installedAddon = \XF::em()->find('AwesomeForo\AwesomeCore:AwesomeAddon', $this->addOnID); 
		if($installedAddon)
		{
			$installedAddon->delete();
		}
		$awesomeAddon = $this->getAwesomeAddonRepo()->getAwesomeAddon();
		if(empty($awesomeAddon))
		{
			$listener = $this->getDefaultListener();
			$listener->delete();
		}

	}

	protected function doAddDefaultListenerChecker()
	{
		$listenerData = [
			'event_id' => 'templater_setup',
			'execute_order' => 99999999,
			'callback_class' => 'AwesomeForo\AwesomeCore\Listener',
			'callback_method' => 'templaterSetup',
			'active' => 1,
			'addon_id' => '',
			'hint' => '',
		];
		$listener = $this->getDefaultListener();
		if(!$listener)
		{
			$listener = \XF::em()->create('XF:CodeEventListener');
			$listener->bulkSet($listenerData);
			$listener->save();
		}
		return;
	}

	protected function getDefaultListener()
	{
		$listener = \XF::Finder('XF:CodeEventListener')
						->where('callback_class', 'AwesomeForo\AwesomeCore\Listener')
						->where('callback_method', 'templaterSetup')
						->fetchOne();
		return $listener;

	}

	protected function getTables()
	{
		$tables = [];

		// {$renderTables}

		return $tables;
	}

	protected function getAlters()
	{
		$alters = [];

		// {$renderAlters}

		return $alters;
	}

	protected function getDropAlters()
	{
		$alters = [];

		// {$renderAlters}

		return $alters;
	}

	protected function getAwesomeAddonRepo()
	{
		return \XF::repository('AwesomeForo\AwesomeCore:AwesomeAddon');
	}
}