﻿<?php

namespace Ghf\TradeFeedback;

use XF\AddOn\AbstractSetup;
use XF\Db\Schema\Create;

class Setup extends AbstractSetup
{
    public function install(array $stepParams = [])
    {
        $this->schemaManager()->createTable('xf_trade_feedback', function(Create $table)
        {
            $table->addColumn('trade_id', 'int')->autoIncrement();
            $table->addColumn('sender_id', 'int')->unsigned(true);
            $table->addColumn('receiver_id', 'int')->unsigned(true);
            $table->addColumn('rating', 'enum')->values(['positive', 'negative', 'neutral']);
            $table->addColumn('message', 'text');
            $table->addColumn('trade_date', 'int')->unsigned(true);
            $table->addColumn('ip_address', 'varbinary', 16);

            $table->addKey('sender_id');
            $table->addKey('receiver_id');
        });
    }

    public function upgrade(array $stepParams = [])
    {
        // No upgrades for version 1.0.0
    }

    public function uninstall(array $stepParams = [])
    {
        $this->schemaManager()->dropTable('xf_trade_feedback');
    }
}
