﻿<?php

namespace Ghf\TradeFeedback\Pub\Controller;

use XF\Entity\User;
use XF\Mvc\ParameterBag;
use XF\Pub\Controller\AbstractController;
use XF\PrintableException;

class TradeSubmit extends AbstractController
{
    protected function preDispatchController($action, ParameterBag $params)
    {
        parent::preDispatchController($action, $params);
        $this->assertRegisteredUser();

        if (!\XF::visitor()->hasPermission('TradeFeedback', 'tradeFeedback_give'))
        {
            throw $this->exception($this->noPermission());
        }
    }

    public function actionIndex(ParameterBag $params)
    {
        $receiver = $this->assertReceiverUser();

        if ($this->isPost())
        {
            return $this->handlePost($receiver);
        }

        $viewParams = [
            'receiver' => $receiver,
            'ratingOptions' => [
                'positive' => 'Positive',
                'negative' => 'Negative',
                'neutral' => 'Neutral'
            ]
        ];

        return $this->view('Ghf\TradeFeedback:TradeSubmit', 'ghf_trade_submit', $viewParams);
    }

    protected function handlePost(User $receiver)
    {
        $input = $this->filter([
            'rating' => 'str',
            'message' => 'str'
        ]);

        /** @var \Ghf\TradeFeedback\Service\TradeCreator $creator */
        $creator = $this->service('Ghf\TradeFeedback:TradeCreator');
        $creator->setSender(\XF::visitor());
        $creator->setReceiver($receiver);
        $creator->setRating($input['rating']);
        $creator->setMessage($input['message']);

        try
        {
            $creator->save();
        }
        catch (PrintableException $e)
        {
            return $this->error($e->getMessage());
        }

        return $this->redirect($this->buildLink('members', $receiver));
    }

    protected function assertReceiverUser(): User
    {
        $receiverId = $this->filter('user_id', 'uint');
        if (!$receiverId)
        {
            throw $this->exception($this->error('Receiver not specified.'));
        }

        /** @var User|null $receiver */
        $receiver = $this->em()->find('XF:User', $receiverId);
        if (!$receiver)
        {
            throw $this->exception($this->notFound());
        }

        if (!$receiver->hasPermission('TradeFeedback', 'tradeFeedback_receive'))
        {
            throw $this->exception($this->noPermission());
        }

        return $receiver;
    }
}

